#include <iostream.h>
#include <fstream.h>
#include "DVector.h"
#include "Util.h"
#include "DString.h"
#include <math.h>
#include <classlib\time.h>
#include <DList.h>

#define MIN_INDEX 1
#define MAX_INDEX 20

void main()
 { Vector<double>						Tmp("Tmp"), Z("Z"), Tmp2("Tmp2");
 	String								fileName, fullFileName;
   String								tmp;
   int									N, k, m, NK, kValue, mValue, mMax, sampleSize,n, T;
   double 								sigmaZ, alpha, hMin, hMax, hStep;
   List<int*>							mList, kList;
   ofstream								outputFile;


	try
    { cout << "Data file name : ";
    	cin >> fileName;
      fullFileName = fileName;

		tmp = fileName;
      tmp += "Median2Result.txt";
	   outputFile.open((char*)tmp);

		outputFile << "Method : median2 " << endl << "File : " << fileName << endl;

      fullFileName += ".txt";
      ifstream(fullFileName) >> Tmp;
      cout << "Sample size : ";
      cin >> sampleSize;

      outputFile << "Sample size : " << sampleSize << endl;

      Z.resize(1,sampleSize);

      cout << "Enter k list (-1 to finish)\n";
      outputFile << "k list : ";
		do
       { cout << "k = ";
       	cin >> kValue;
         if (kValue != -1)
          {	kList.addObject(new int(kValue));
         	outputFile << kValue << " ";
          }
       }
      while(kValue != -1);
      outputFile << endl;

      cout << "Enter m list (-1 to finish)\n";
      outputFile << "m list : ";
      mMax = -1;
		do
       { cout << "m = ";
       	cin >> mValue;
         if (mValue > mMax)
         	mMax = mValue;
         if (mValue != -1)
          {	mList.addObject(new int(mValue));
          	outputFile << mValue << " ";
          }
       }
      while(mValue != -1);
      outputFile << endl;
      cout << "alpha=";
      cin >> alpha;

      outputFile << "alpha : " << alpha << endl;

      for (int i = Z.minIndex();i <= Z.maxIndex();i++)
      	Z[i] = Tmp[i];


      T = Z.size()-mMax;

      cout << "T=" << T << endl;
      outputFile << "T = " << T << endl;

      Tmp2.resize(1,T);
      for (int i = Tmp2.minIndex();i <= Tmp2.maxIndex();i++)
      	Tmp2[i] = Tmp[i];


      sigmaZ = sigma(Tmp2);
      cout << "sigmaZ = " << sigmaZ << endl;

      cout << "NK = ";
      cin >> NK;
		outputFile <<  "NK = " << NK << endl;
      outputFile << "Sigma Z = " << sigmaZ << endl;

      Vector<double>	hMin("hMin",0,kList.count() - 1), hMax("hMax",0,kList.count() - 1);
      for (int kIndex = 0;kIndex < kList.count();kIndex++)
       { k = *(kList[kIndex]);
         cout << "h1["<< k << "] = " << sigmaZ*powl(T,(-1.0/(double)(k+4))) << endl;
         cout << "hMin["<< k << "] = ";
         cin >> hMin[kIndex];
         cout << "hMax["<< k << "] = ";
         cin >> hMax[kIndex];
		   outputFile << "h1["<< k << "] = " << sigmaZ*powl(T,(-1.0/(double)(k+4))) << "\thMin["<< k << "] = " << hMin[kIndex] << "\thMax["<< k << "] = " << hMax[kIndex] << endl;
       }

   TTime									begin;

      for (int kIndex = 0;kIndex < kList.count();kIndex++)
       { k = *(kList[kIndex]);
         cout << endl << "-----" << endl << "----- k = " << k << endl << "-----" << endl << endl;
         outputFile << endl << "-----" << endl << "----- k = " << k << endl << "-----" << endl << endl;
         for (int listIndex = 0;listIndex < mList.count();listIndex++)
          { double 				   h1, hOp, cvOpValue;
				m = *(mList[listIndex]);

            cout << m << " ";
            outputFile << m << " ";
            Vector<double>						Y("Y");
			 	Vector< Vector<double> >      X("X");

				// -----> Construction de Xi et Yi

 				n = T-m;

				Y.resize(k,n);
		      X.resize(k,T);

     	      for (int i = k;i <= T;i++)
		       { if (i <= n)
               	Y[i] = Z[i+m];
		       	X[i].resize(1, k);
         		tmp = "X";
         		tmp += i;
         		X[i].rename(tmp);
       			for (int j = i, xiIndex = 1;j >= i-k + 1;j--,xiIndex++)
         			X[i][xiIndex] = Z[j];
		       }
				Y.initMinMax();

      		Vector <double>   F("F",Y.minIndex(),Y.maxIndex()), x("x",1,k), sortedY("sortedY", Y.minIndex(), Y.maxIndex());

		      // -----> calcul de h1 et de hop

       //   h1 = sigmaZ*powl(T,(-1.0/(double)(k+4)));
	    //   hOp = h1 * (1.55*1.0/(double)(NK-1) + 0.05 - 1.55/(double)(NK - 1));
            hStep = (hMax[kIndex] - hMin[kIndex])/(NK-1);
            hOp = hMin[kIndex];
		      cvOpValue = CV2Median(X,Y, n, hOp,k);
		      bool  foundHop = false;
		      for (int l = 2;l <= NK; l++)
		       { double hValue;
//		       	hValue = h1 * (1.55*(double)l/(double)(NK-1) + 0.05 - 1.55/(double)(NK - 1));
 					hValue = hMin[kIndex] + (l-1)*hStep;
		        	double cvValue;
         		if ((cvValue = CV2Median(X,Y, n, hValue,k)) < cvOpValue)
		          { hOp = hValue;
		           	cvOpValue = cvValue;
		            foundHop = true;
		          }
		         else
		          { if (foundHop)		// la fonction ne possde pas de minimum local
		               break;
		          }
		       }
  				cout << hOp << " ";
            outputFile << hOp << " ";

		      // -----> Calcul de Zn+m

            double ZValue = Z_nm_median2(X, Y, T, hOp, k, n);

				cout << Z[T+m] << " " << ZValue << " ";
            outputFile << Z[T+m] << " " << ZValue << " ";

		      double 				a1 = 0.25 - alpha / 4.0,
		       						a2 = 1 - alpha,
		        						minv = 2000,
		                    		f1 = 10,
		                    		f2 = 10,
		                    		cover = 0,
		                        percen = 0,
                              tmp = 0;


		      // -----> Predictive Region

		      for (int i = Y.minIndex();i <= Y.maxIndex();i++)
		       	F[i] = F_y_Xn(X, Y, Y[i], n, T, hOp, k);

		      sortedY = Y;
		      bool change = true;

		      // tri des F(Yi/Xn)

				while (change)
		       { change = false;
		        	for (int j = F.minIndex();j <= F.maxIndex() - 1;j++)
		          { if (F[j] > F[j+1])
		          	 { change = true;
      		         tmp = F[j+1];
		             	F[j+1] = F[j];
		               F[j] = tmp;
		               tmp = sortedY[j+1];
		               sortedY[j+1] = sortedY[j];
		               sortedY[j] = tmp;
		             }
		          }
		       }
		      bool min = false,
		      	  max = false;
		      for (int i = F.minIndex();i <= F.maxIndex() && (!min || !max);i++)
		       { if (!min && F[i] >= 0.5 - alpha/2)
		       	 { min =true;
		          	cout << "[" << sortedY[i] << ",";
                  outputFile <<  "[" << sortedY[i] << ",";
		          }
		         if (!max && F[i] >= 0.5 + alpha/2)
		          { max = true;
		          	cout << sortedY[i] << "]" << " ";
                  outputFile << sortedY[i] << "]" << " ";
		          }
		       }

		   	// tri des F(Yi/Xn)

		     change = true;

				while (change)
		       { change = false;
		        	for (int j = F.minIndex();j <= F.maxIndex() - 1;j++)
		          { if (sortedY[j] > sortedY[j+1])
		          	 { change = true;
		               tmp = F[j+1];
		             	F[j+1] = F[j];
		               F[j] = tmp;
		               tmp = sortedY[j+1];
		               sortedY[j+1] = sortedY[j];
		               sortedY[j] = tmp;
		             }
		          }
		       }



		      // ------> Calcul du SCMI

		      for (int i = Y.minIndex();i <= Y.maxIndex();i++)
		       { /*if (F[i] < a1)
		        	 	continue;*/
		         /*if (F[i] > a2)
		           	break;*/
		         for (int j = i + 1;j <= Y.maxIndex();j++)
				    { if ((percen = F[j] - F[i]) >= alpha)
		          	 { tmp = sortedY[j] - sortedY[i];
		             	if ((tmp < minv) || ((tmp == minv) && (percen > cover)))
		                { f1 = sortedY[i];
		                  f2 = sortedY[j];
		                  cover = percen;
		                }
		               break;
		             }
		          }
		       }
		      cout << "[" << f1 << "," << f2 << "]" << " (" << cover << ") " ;
            outputFile  << "[" << f1 << "," << f2 << "]"  << " (" << cover << ") ";

		    	// -----> Calcul du MCDR

		    minv = 10e100;
          f1 = f2 = 10;

		    double f3 = 10,f4 = 10,p = 0, i1 = 0, i2 = 0;

		    for (int i = F.minIndex();i < F.maxIndex() - 1;i++)
		     { /*if (F[i] < a1)
           		 continue;
           	 if (F[i] > a2)
             	 break;   */
             for (int j = i + 1;j <= F.maxIndex() - 1;j++)
		     	  { for (int k = j;k <= F.maxIndex() - 1;k++)
		        	  { //if (sortedY[j] - sortedY[i] <= minv)
                   for (int l = k + 1;l <= F.maxIndex() - 1;l++)
		              { if ((percen = (F[j] - F[i] + F[l] - F[k])) >= alpha)
		                 { double tmp2 = sortedY[j] - sortedY[i] + sortedY[l] - sortedY[k];
		                 	 if (tmp2 < minv)
		                    { f1 = sortedY[i];
		                    	 f2 = sortedY[j];
		                      f3 = sortedY[k];
		                      f4 = sortedY[l];
		                      minv = tmp2;
		                      p = percen;
                            i1= F[j] - F[i];
                            i2=F[l] - F[k];
		                    }
                         else
		                    { if (tmp2 == minv && percen > p)
		                       { f1 = sortedY[i];
		                    	    f2 = sortedY[j];
                               f3 = sortedY[k];
                               f4 = sortedY[l];
		                         minv = tmp2;
		                         p = percen;
                            	 i1= F[j] - F[i];
                            	 i2=F[l] - F[k];
		                       }
                          }
		                 }
		              }
		           }
		        }
		     }
			cout << "[" << f1 << "," << f2 << "]U[" << f3 << "," << f4 << "] " << "(" << i1 << ","<<i2 << ")";
         outputFile << "[" << f1 << "," << f2 << "]U[" << f3 << "," << f4 << "] " << "(" << i1 << ","<<i2 << ")";

       cout << endl;
       outputFile << endl;
       }
    }
   TTime				end;

   TTime          resultTime(TTime(0) + end.Seconds() - begin.Seconds());
   resultTime.PrintDate(0);

   cout << endl << "Duration : " <<  resultTime.HourGMT() << "h:" << resultTime.MinuteGMT()<< "mm:" << resultTime.Second() << "s" << endl;
   outputFile << endl << "Duration : " <<  resultTime.HourGMT() << "h:" << resultTime.MinuteGMT()<< "mm:" << resultTime.Second() << "s" << endl;
 }
   catch(VectorError &anError)
    { cout << endl << "Error from " << anError.vectorName() << " : " << anError.why() << endl;
      outputFile << endl << "Error from " << anError.vectorName() << " : " << anError.why() << endl;
    }
   catch(StatError &anError)
    { cout << endl << "Error from " << anError.where() << " : " << anError.why() << endl;
      outputFile << endl << "Error from " << anError.where() << " : " << anError.why() << endl;
    }
   catch(...)
    { cout << endl << "Undefined error" << endl;
      outputFile << endl << "Undefined error" << endl;
    }

 }
